USE AdventureWorks2017;
GO

--All columns and all rows
--Not cool!
SELECT * 
FROM HumanResources.Department;

SELECT * 
FROM Person.Person;

--Specify the columns you need
SELECT DepartmentID, Name
FROM HumanResources.Department;

SELECT BusinessEntityID, FirstName, MiddleName, LastName 
FROM Person.Person;

--End DEMO

--Filtering with the WHERE clause
--Put tick marks around strings and dates!
SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name = 'Engineering';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name <> 'Engineering';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name != 'Engineering';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID IN (2,3,4);

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID NOT IN (2,3,4);

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID BETWEEN 1 AND 10;

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID > 9;

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID >= 9;

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE DepartmentID <= 9;

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE 'T%';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name NOT LIKE 'T%';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%T%';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%K%';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%ing';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%ing%ing';


SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%ing' AND 
	GroupName = 'Research and Development';

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%ing' OR 
	GroupName = 'Research and Development';

/*
Find the departments that have an o or a d, 
but they must be in the R&D group
*/
SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name LIKE '%o%' OR Name LIKE '%d%' 
	AND GroupName = 'Research and Development';

--Use Parentheses to enforce logic
SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE (Name LIKE '%o%' OR Name LIKE '%d%') 
	AND GroupName = 'Research and Development';


--End Demo


--NULLs
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product;

--Find a list of products that do not have a color
--This doesn't work!
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color = NULL;

--Use the IS NULL operator instead
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color IS NULL;

--Find the products that do have a color
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color IS NOT NULL;

--Find the blue products
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color ='Blue';


--Find the products that are not blue
--Returns just the products that have a color
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color <> 'Blue';

--Use a function to change NULLs to another value
--Returns all products that are not blue
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE ISNULL(Color,'N/A') <> 'Blue';

SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE COALESCE(Color,'N/A') <> 'Blue';

--Use OR
SELECT ProductID, Name, Color, Size, Style
FROM Production.Product
WHERE Color <> 'Blue' OR Color IS NULL;

--End demo

--Ordering 
SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
ORDER BY DepartmentID; 

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
ORDER BY DepartmentID DESC; 

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
ORDER BY GroupName, DepartmentID; 

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
ORDER BY GroupName DESC, DepartmentID; 

SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
ORDER BY 3, 1; 

















SELECT DepartmentID, Name, GroupName
FROM HumanResources.Department
WHERE Name > 'T';



















